const { connectToMySQL, getPool } = require('./config/db');
require('dotenv').config();

async function checkData() {
    try {
        await connectToMySQL();
        const pool = getPool();
        const [rows] = await pool.query('SELECT id, data->>"$.category" as category, data->>"$.title" as title, created_at FROM news');
        console.log('News in DB:', JSON.stringify(rows, null, 2));

        const [catRows] = await pool.query('SELECT * FROM categories');
        console.log('Categories in DB:', JSON.stringify(catRows, null, 2));

        process.exit(0);
    } catch (err) {
        console.error(err);
        process.exit(1);
    }
}

checkData();
