const express = require('express');
const router = express.Router();
const {
    register,
    login,
    logout,
    verifyAuth,
    getProfile,
    updateProfile,
    changePassword,
    getAllUsers,
    updateAdminUser,
    deleteUser
} = require('../controllers/authController');
const { authMiddleware } = require('../middleware/authMiddleware');


router.post('/register', register);
router.post('/login', login);


router.post('/logout', authMiddleware, logout);
router.get('/verify', authMiddleware, verifyAuth);
router.get('/profile', authMiddleware, getProfile);
router.put('/profile', authMiddleware, updateProfile);
router.post('/change-password', authMiddleware, changePassword);


router.get('/users', authMiddleware, getAllUsers);
router.put('/users/:userId', authMiddleware, updateAdminUser);
router.delete('/users/:userId', authMiddleware, deleteUser);

module.exports = router;
