const express = require('express');
const router = express.Router();
const { authMiddleware, authorize } = require('../middleware/authMiddleware');
const { getDB } = require('../config/db');


router.get('/', async (req, res) => {
    try {
        const db = getDB();
        let categories = await db.collection('categories').find({}).toArray();

        
        if (categories.length === 0) {
            const defaults = [
                { name: 'Politics', slug: 'politics' },
                { name: 'Business', slug: 'business' },
                { name: 'Sports', slug: 'sports' },
                { name: 'Entertainment', slug: 'entertainment' },
                { name: 'Technology', slug: 'technology' },
                { name: 'Health', slug: 'health' }
            ];
            for (const cat of defaults) {
                await db.collection('categories').insertOne(cat);
            }
            categories = await db.collection('categories').find({}).toArray();
        }

        res.json({
            success: true,
            data: categories
        });
    } catch (error) {
        res.status(500).json({
            success: false,
            message: 'Error fetching categories',
            error: error.message
        });
    }
});


router.post('/', authMiddleware, authorize('super-admin'), async (req, res) => {
    try {
        const { name } = req.body;
        if (!name) return res.status(400).json({ success: false, message: 'Name is required' });

        const slug = name.toLowerCase().replace(/ /g, '-').replace(/[^\w-]+/g, '');
        const db = getDB();

        const result = await db.collection('categories').insertOne({ name, slug });
        res.status(201).json({ success: true, data: { id: result.insertedId, name, slug } });
    } catch (error) {
        res.status(500).json({ success: false, message: 'Error creating category', error: error.message });
    }
});

module.exports = router;
