const express = require('express');
const router = express.Router();
const { getDB } = require('../config/db');
const { v4: uuidv4 } = require('uuid');
const { sendWelcomeEmail } = require('../utils/emailService');

router.post('/subscribe', async (req, res) => {
    try {
        const { email } = req.body;

        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!email || !emailRegex.test(email)) {
            return res.status(400).json({ success: false, message: 'Please provide a valid email address' });
        }

        const db = getDB();

        // Check if subscriber exists
        const existing = await db.collection('subscribers').findOne({ email: email.toLowerCase() });
        if (existing) {
            return res.status(400).json({ success: false, message: 'This email is already subscribed' });
        }

        const subscriber = {
            id: uuidv4(),
            email: email.toLowerCase(),
            subscribed_at: new Date().toISOString(),
            status: 'active'
        };

        await db.collection('subscribers').insertOne(subscriber);

        // Send Welcome Email
        await sendWelcomeEmail(email);

        res.status(200).json({ success: true, message: 'Successfully subscribed to newsletter!' });
    } catch (error) {
        console.error('Newsletter Subscription Error:', error);
        res.status(500).json({ success: false, message: 'Error processing subscription. Please try again later.' });
    }
});

module.exports = router;
