const bcrypt = require('bcryptjs');
require('dotenv').config();
const { connectToMySQL, getDB } = require('../config/db');

async function createSuperAdmin() {
    try {
        
        await connectToMySQL();
        const db = getDB();

        
        const email = 'rustamchupa473@gmail.com';
        const password = 'Deepakrajput@321';
        const name = 'Super Admin';
        const role = 'super-admin';

        
        const existingUsers = await db.collection('users').find({ email }).toArray();
        if (existingUsers && existingUsers.length > 0) {
            console.log('❌ User already exists with email:', email);
            process.exit(0);
        }

        
        const salt = await bcrypt.genSalt(10);
        const hashedPassword = await bcrypt.hash(password, salt);

        
        const userData = {
            email,
            password: hashedPassword,
            name,
            role,
            isActive: true,
            createdAt: new Date(),
            updatedAt: new Date()
        };

        
        const result = await db.collection('users').insertOne(userData);

        console.log('✅ Super Admin created successfully!');
        console.log('');
        console.log('📧 Email:', email);
        console.log('🔑 Password:', password);
        console.log('🏷️ Role:', role);
        console.log('');
        console.log(`You can now login at: ${process.env.FRONTEND_URL || 'http://localhost:5173'}/super-admin/login`);

        process.exit(0);
    } catch (error) {
        console.error('❌ Error creating super admin:', error);
        process.exit(1);
    }
}

createSuperAdmin();
