const axios = require('axios'); 



const BASE_URL = 'http://localhost:5000/api';

async function testContactFlow() {
    try {
        console.log('1. Logging in as Super Admin...');
        const loginRes = await fetch(`${BASE_URL}/auth/login`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                email: 'rustamchupa473@gmail.com',
                password: 'Deepakrajput@321'
            })
        });

        const loginData = await loginRes.json();
        
        if (!loginData.success) {
            console.error('❌ Login failed:', loginData);
            return;
        }

        const token = loginData.data.token;
        console.log('✅ Login successful. Token obtained.');

        console.log('\n2. Sending a test contact message (Public)...');
        const messagePayload = {
            name: 'API Tester',
            email: 'apitester@example.com',
            subject: 'API Test Subject',
            message: 'This message was sent via test-api-full.js'
        };

        const sendRes = await fetch(`${BASE_URL}/contact`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(messagePayload)
        });

        const sendData = await sendRes.json();
        if (!sendData.success) {
            console.error('❌ Send message failed:', sendData);
            return;
        }
        console.log('✅ Message sent successfully.');
        const newMessageId = sendData.data.id;

        console.log('\n3. Fetching messages as Admin...');
        const fetchRes = await fetch(`${BASE_URL}/contact`, {
            method: 'GET',
            headers: {
                'Authorization': `Bearer ${token}`,
                'Content-Type': 'application/json'
            }
        });

        if (fetchRes.status !== 200) {
            console.error(`❌ Fetch failed with status ${fetchRes.status}`);
            const errorText = await fetchRes.text();
            console.error('Response:', errorText);
            return;
        }

        const fetchData = await fetchRes.json();
        console.log(`✅ Fetch successful. Retrieved ${fetchData.data.length} messages.`);

        const found = fetchData.data.find(m => m.id === newMessageId);
        if (found) {
            console.log('✅ SUCCESS: Newly sent message found in admin list.');
            
            
            console.log('\n4. Cleaning up (Deleting test message)...');
            const deleteRes = await fetch(`${BASE_URL}/contact/${newMessageId}`, {
                method: 'DELETE',
                headers: {
                    'Authorization': `Bearer ${token}`
                }
            });
            if (deleteRes.ok) {
                 console.log('✅ Test message deleted.');
            } else {
                console.log('⚠️ Failed to delete test message.');
            }

        } else {
            console.error('❌ FAILURE: Newly sent message NOT found in admin list.');
            console.log('List IDs:', fetchData.data.map(m => m.id));
        }

    } catch (error) {
        console.error('❌ Script error:', error);
    }
}

testContactFlow();
